<html>
<!--
© freiherr von hermes [https://cloudwork-orange.com/]
license: eupl v.1.1 [https://joinup.ec.europa.eu/collection/eupl/eupl-text-11-12]
-->

<head>
    <title>MAC-Address Lookup Vendor and Manufacturer</title>
    <meta name="description" content="Lookup the Manufacturer/Vendor of a MAC-Address">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <style>
        * {
            box-sizing: border-box;
        }

        html {
            font-family: sans-serif;
            font-size: 16px;
            line-height: 1.6rem;
        }

        body,
        h1,
        h2,
        h3,
        h4,
        p {
            margin: 0;
        }

        body {
            margin: 1.6rem;
        }

        h1 {
            line-height: 3.2rem;
        }

        label,
        input {
            font-size: 1rem;
        }

        code {
            display: block;
            width: 100%;
            white-space: pre;
            font-size: 14px;
            font-family: monospace;
            line-height: 18px;
        }

        a {
            text-decoration: underline;
        }

        .macAddressInputForm {
            background: #eee;
            margin: .8rem -.6rem 1.6rem -.6rem;
            padding: .6rem;
        }

        .macAddressPrefix,
        .vendorData,
        .vendorAdditionalMacAddressPrefixes {
            margin-top: 1.6rem;
        }

        .additionalPrefixesList {
            font-size: .5rem;
            line-height: .8rem;
            text-align: justify;
        }

        .apiInfo {
            margin-top: 1.6rem;
            max-height: 1.6rem;
            overflow: hidden;
            transition: max-height .5s ease-out;
        }

        .apiInfo:hover {
            max-height: 32rem;
        }

        .vendorMap {
            position: relative;
            margin: .8rem -.6rem 1.6rem -.6rem;
            background: #eee;
        }

        .vendorMapOverlay {
            display: block;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: 1;
        }

        .vendorMapIframe {
            display: block;
            border: none;
            background: transparent;
            z-index: -1;
        }

        .footer,
        .small {
            font-size: .8em;
        }

        .footer {
            margin: 1.6rem -.6rem 0 -.6rem;
            background: #eee;
            padding: .6rem;
        }

        .row {
            display: flex;
        }

        .column {
            flex-grow: 1;
        }

        .column.vendorMap {
            flex-grow: 5;
        }
    </style>
</head>

<body>
    <h1>MAC-Address Vendor Lookup</h1>
    <h2>Lookup the Vendor/Manufacturer of a MAC-Address:</h2>
    <form class="macAddressInputForm" action="" method="get">
        <p>Enter <strong>MAC-Address</strong> (-prefix) to <strong>lookup</strong> <strong>vendor</strong> information:</p>
        <label for="macaddress">MAC-Address:</label>
        <input type="text" name="macaddress" placeholder="01:23:45:67:89:AB" <?php echo (isset($_GET["macaddress"]) ? " value=\"" . $_GET["macaddress"] . "\"" : ""); ?>>
        <input type="submit">
        <p>E.G.:<br>
            <a href="https://cloudwork-orange.com/projects/macAddressLookup/?macaddress=E8%3A85%3A4B">Apple - E8:85:4B: …</a>
            <a href="https://cloudwork-orange.com/projects/macAddressLookup/?macaddress=58%3ACB%3A52">Google - 58:CB:52: …</a>
            <a href="https://cloudwork-orange.com/projects/macAddressLookup/?macaddress=F4%3ABD%3A9E">Cisco - F4:BD:9E: …</a>
            <a href="https://cloudwork-orange.com/projects/macAddressLookup/?macaddress=98%3AE8%3AFA">Nintendo - 98:E8:FA: …</a>
            <a href="https://cloudwork-orange.com/projects/macAddressLookup/?macaddress=D0%3AD0%3A03">Samsung - D0:D0:03: …</a>
        </p>
        <div class="apiInfo">
            <p><strong><a>Howto?</a></strong></p>
            <p class="small">As always you can download the source code of this project right here: [<a href="./_archive/macAddressVendorLookup.7z">macAddressVendorLookup.7z</a>]
                <br>Alternatively, you could fetch my current [<a href="./_databases_/vendorPrefixes.db">vendorPrefixes.db</a> sqlite database.
            </p>
            <p>Or, if you're in a real hurry, you could use my lookup api to incorporate vendor lookup right into your project.
                <br>Example:
            </p>
            <code><?php
                    $exampleCode = file_get_contents("_includes/apiExample.php");
                    echo htmlentities($exampleCode);
                    unset($exampleCode);
                    ?></code>
        </div>
    </form>

    <?php
    if (isset($errorMessages) && 0 != count($errorMessages)) {
    ?>
        <div class="errors">
            <?php
            echo implode("<br>" . PHP_EOL, $errorMessages);
            ?>
        </div>
    <?php
    } elseif (isset($result) && false != $result) {
    ?>
        <div class="lookupResult">
            <div class="row">
                <div class="column">
                    <h2>Matching Vendor: <?php echo $result["vendorName"]; ?></h2>
                    <div class="macAddressPrefix">
                        <h3>Statistics of prefix <?php echo $result["macAddressPrefix"]; ?>:</h3>
                        <p>First available MAC-Address in this prefix:
                            <br><?php echo $result["macAddressPrefix"] . ":00:00:00"; ?> (hexadecimal) – <?php echo base_convert($result["macAddressPrefix"] . ":00:00:00", 16, 10); ?> (decimal)
                        </p>
                        <p>Last available MAC-Address:
                            <br><?php echo $result["macAddressPrefix"] . ":FF:FF:FF"; ?> (hexadecimal) – <?php echo base_convert($result["macAddressPrefix"] . ":FF:FF:FF", 16, 10); ?> (decimal)
                        </p>
                    </div>

                    <div class="vendorData">
                        <div class="vendorName">
                            <h3><?php echo $result["vendorName"]; ?>:</h3>
                        </div>
                        <div class="vendorAddress">
                            <?php echo preg_replace("/,([^\s])/", ", $1", $result["vendorAddressStreet"]); ?>
                            <br>
                            <?php echo preg_replace("/,([^\s])/", ", $1", $result["vendorAddressCity"]); ?>,
                            <?php echo $result["vendorAddressCountry"]; ?>
                        </div>
                    </div>
                </div>
                <div class="column vendorMap">
                    <iframe class="vendorMapIframe" src="https://nominatim.openstreetmap.org/ui/search.html?q=<?php echo rawurlencode(preg_replace("/[^\w\.]+/", " ", $result["vendorAddressCity"])); ?>&amp;limit=1&amp;polygon=1&amp;format=html&amp;addressdetails=1" width="100%" height="640px"></iframe>
                    <a class="vendorMapOverlay" target="_blank" rel="noreferrer nofollow noopener" href="https://nominatim.openstreetmap.org/ui/search.html?q=<?php echo rawurlencode(preg_replace("/[^\w\.]+/", " ", $result["vendorAddressCity"])); ?>&amp;limit=1&amp;polygon=1&amp;format=html&amp;addressdetails=1"></a>
                </div>
            </div>
            <?php
            if (0 < count($result["vendorMacAddressPrefixes"])) {
            ?>
                <div class="vendorAdditionalMacAddressPrefixes">
                    <h3>All MAC-Address Prefixes of this Manufacturer:</h3>
                    <p>This vendor has a total of <?php echo number_format($result["vendorMacAddressPrefixesCount"], 0, ".", ","); ?> prefixes assigned. Total number of available MAC-Addresses therefore is <?php echo number_format($result["vendorMacAddressesCount"], 0, ".", ","); ?> Units:</p>

                    <div class="additionalPrefixesList">
                        <?php
                        foreach ($result["vendorMacAddressPrefixes"] as $macAddressPrefix) {
                            $formattedAddressPrefix = $macAddressPrefix;
                            echo "<a href=\"?macaddress=" . rawurlencode($macAddressPrefix) . "\">" . $formattedAddressPrefix . "</a> ";
                        }
                        ?>
                    </div>
                </div>
            <?php
            }
            ?>

        </div>
    <?php
    }
    ?>
    <div class="footer">© freiherr von hermes [<a href="https://cloudwork-orange.com/" target="_blank" rel="noopener">https://cloudwork-orange.com/</a>] - licensed under the eupl v.1.1 [<a href="https://joinup.ec.europa.eu/collection/eupl/eupl-text-11-12" target="_blank" rel="noopener">https://joinup.ec.europa.eu/collection/eupl/eupl-text-11-12</a>]</div>
</body>

</html>
