<?php
include_once("./_includes/init.php");

if (is_file($databaseFilename)) {
    if (isset($_GET["macaddress"])) {
        $_GET["macaddress"] = iconv('UTF8', 'ASCII//IGNORE', mb_strtoupper($_GET["macaddress"]));
        $_GET["macaddress"] = preg_replace("/[^0-9A-F]/", "", $_GET["macaddress"]);
        $_GET["macaddress"] = trim($_GET["macaddress"]);
        $_GET["macaddress"] = mb_substr($_GET["macaddress"], 0, 6);

        if (!preg_match("/^[0-9A-F]{6}$/", $_GET["macaddress"])) unset($_GET["macaddress"]);

        $errorMessages = array();

        $databaseObject = new PDO("sqlite:" . $databaseFilename);
        if (false === $statement = $databaseObject->prepare("SELECT * FROM vendorPrefixes WHERE \"macAddressPrefix\" = :macAddressPrefix")) {
            $errorMessages[] = "Err: Could not connect to database.";
        }
        $statement->bindParam(":macAddressPrefix", $_GET["macaddress"]);

        if (false === $statement->execute()) {
            $errorMessages[] = "Err: Could not query database.";
        }

        if (false === $result = $statement->fetch(PDO::FETCH_ASSOC)) {
            if (in_array(substr($_GET["macaddress"], 1, 1), array('2', '6', 'A', 'E'))) {
                $errorMessages[] = "Err: \"" . $_GET["macaddress"] . "\" is probably a private/randomized MAC-Address.";
            } else {
                $errorMessages[] = "Err: Vendor prefix \"" . $_GET["macaddress"] . "\" not found.";
            }
        } else {
            $result["macAddressPrefixBase16"] = $result["macAddressPrefix"];
            $result["macAddressPrefixDecimal"] = base_convert($result["macAddressPrefix"], 16, 10);
            $result["macAddressPrefix"] = substr($result["macAddressPrefix"], 0, 2) . ":" . substr($result["macAddressPrefix"], 2, 2) . ":" . substr($result["macAddressPrefix"], 4, 2);

            if (false === $statement = $databaseObject->prepare("SELECT macAddressPrefix FROM vendorPrefixes WHERE \"vendorName\" = :vendorName")) {
                $errorMessages[] = "Err: Could not connect to database.";
            }
            $statement->bindParam(":vendorName", $result["vendorName"]);
            if (false === $statement->execute()) {
                $errorMessages[] = "Err: Could not query database.";
            }
            $result["vendorMacAddressPrefixes"] = $statement->fetchAll(PDO::FETCH_ASSOC);
            foreach ($result["vendorMacAddressPrefixes"] as $key => $value) {
                $result["vendorMacAddressPrefixes"][$key] = substr($value["macAddressPrefix"], 0, 2) . ":" . substr($value["macAddressPrefix"], 2, 2) . ":" . substr($value["macAddressPrefix"], 4, 2);
            }

            $result["vendorMacAddressPrefixesCount"] = count($result["vendorMacAddressPrefixes"]);
            $result["vendorMacAddressesCount"] = pow(16, 6) * $result["vendorMacAddressPrefixesCount"];
        }
    }
}

if (isset($_GET["format"]) && "json" == $_GET["format"]) {
    include("outputJson.php");
} else {
    include("outputHtml.php");
}

ignore_user_abort(true);
closeConnection();

if (filemtime($databaseFilename) < time() - 60 * 60 * 24 * 7) {
    // run update database script once a week …
    include_once("_includes/updateDatabase.php");
}
