<?php
include_once("./_includes/init.php");
ignore_user_abort(true);

ini_set('memory_limit', '512M');
ini_set('max_execution_time', 300);
set_time_limit(300);

$lockFile = $localCacheFile . ".lock";
$scriptTimeout = 60 * 30; // yes, it can take up to 10 minutes - whoohay

if (!is_file($lockFile) || filemtime($lockFile) < time() - $scriptTimeout) { // if no lock file exists or file is too old (crashed?)
    touch($lockFile);
    clearstatcache();

    if (!is_file($localCacheFile) || filemtime($localCacheFile) < time() - 60 * 60 * 24 * 7) { // update once a week …
        set_time_limit($scriptTimeout + 60);

        $fakeUserAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.131 Safari/537.36";
        if (isset($_SERVER["HTTP_USER_AGENT"])) $fakeUserAgent = $_SERVER["HTTP_USER_AGENT"];

        $curlHandle = curl_init($dataUrl);
        curl_setopt($curlHandle, CURLOPT_USERAGENT, $fakeUserAgent);
        curl_setopt($curlHandle, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($curlHandle, CURLOPT_TIMEOUT, $scriptTimeout);
        $source = curl_exec($curlHandle);

        if (false === $source) die("Err: " . curl_error($curlHandle) . "[" . $url . "]");
        curl_close($curlHandle);

        file_put_contents($localCacheFile, $source);
        unset($fakeUserAgent, $source, $curlHandle);
    }

    $fileHandle = fopen($localCacheFile, "r");
    try {
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ];
        $databaseObject = new PDO("sqlite:" . $databaseFilename);
        if (false === $databaseObject->exec("CREATE TABLE IF NOT EXISTS vendorPrefixes (\"macAddressPrefix\" CHAR PRIMARY KEY ASC, \"vendorName\" TEXT, \"vendorAddressStreet\" TEXT DEFAULT NULL, \"vendorAddressCity\" TEXT DEFAULT NULL, \"vendorAddressCountry\" TEXT DEFAULT NULL);")) die("Could not recreate lookup table.");

        $insertStatement = $databaseObject->prepare("INSERT INTO vendorPrefixes (\"macAddressPrefix\", \"vendorName\", \"vendorAddressStreet\", \"vendorAddressCity\", \"vendorAddressCountry\") VALUES(:macAddressPrefix, :vendorName, :vendorAddressStreet, :vendorAddressCity, :vendorAddressCountry);");

        $insertStatement->bindParam(":macAddressPrefix", $macAddressPrefix);
        $insertStatement->bindParam(":vendorName", $vendorName);
        $insertStatement->bindParam(":vendorAddressStreet", $vendorAddressStreet);
        $insertStatement->bindParam(":vendorAddressCity", $vendorAddressCity);
        $insertStatement->bindParam(":vendorAddressCountry", $vendorAddressCountry);
    } catch (PDOException $exception) {
        die($exception->getMessage());
    }

    // begin transaction so we can just ignore the update if anything goes wrong
    $databaseObject->beginTransaction();

    $databaseObject->query("DELETE FROM vendorPrefixes;");

    // insert sample data into first row …
    $macAddressPrefix = "012345";
    $vendorName = "Example Corp";
    $vendorAddressStreet = "Justas Treet 123";
    $vendorAddressCity = "3.1415926 5.3589793";
    $vendorAddressCountry = "XY";
    $insertStatement->execute();

    $macAddressPrefix = false;
    $lineCount = 99;
    $foundPrefixes = array();

    // insert the real data, we just fetched:
    while ($line = fgets($fileHandle)) {
        if (strstr($line, " (base 16)	")) {

            if (false != $macAddressPrefix) {
                // write previous entry to database
                if (false === $insertStatement->execute()) {
                    var_dump($macAddressPrefix, $vendorName, $vendorAddressStreet, $vendorAddressCity, $vendorAddressCountry);
                    die("Error while inserting data …");
                }
            }

            // prepare next entry …
            $vendorAddressStreet = "";
            $vendorAddressCity = "";
            $vendorAddressCountry = "";

            $entry = explode("\t", trim($line));
            $macAddressPrefix = mb_strtoupper(substr($entry[0], 0, 6));
            $macAddressPrefixBase10 = base_convert($macAddressPrefix, 16, 10);

            if (isset($foundPrefixes[$macAddressPrefixBase10])) { // entry already exists
                $lineCount = 99;
                $macAddressPrefix = false;
                continue;
            }

            $foundPrefixes[$macAddressPrefixBase10] = true;
            $vendorName = $entry[2];

            $lineCount = 1;
            continue;
        }

        // process the follwing address lines
        $line = trim($line);
        if (1 == $lineCount) {
            $vendorAddressStreet = $line;
        } elseif (2 == $lineCount) {
            $vendorAddressCity = $line;
        } elseif (3 == $lineCount) {
            $vendorAddressCountry = $line;
        }

        $lineCount++;
    }

    // looks like we"re good to go, let"s commit the update!
    $databaseObject->commit();
    unlink($lockFile);
}
