<?php

// config
$databaseFilename = "./_databases_/vendorPrefixes.db";
$dataUrl = "https://standards-oui.ieee.org/oui/oui.txt";
$localCacheFile = "./_import_/oui.txt";

// initializations
if (function_exists("header_remove")) {
    header_remove("X-Powered-By");
    header_remove("X-UA-Compatible");
}

// global functions
function gz_ob_callback($bufferString) {
    if (isset($_SERVER["HTTP_ACCEPT_ENCODING"]) && stripos($_SERVER["HTTP_ACCEPT_ENCODING"], "gzip") !== false) {
        $bufferString = gzencode($bufferString, 6);
        @header('Content-Encoding: gzip');
        @header('Vary: Accept-Encoding');
    }

    $cacheForThisManySeconds = 31536000; //60*60*24*365;
    @header("Pragma: public");
    @header("Cache-Control: public, max-age=" . $cacheForThisManySeconds, true);
    @header("Expires: " . gmdate("D, d M Y H:i:s", time() + $cacheForThisManySeconds) . " GMT", true);
    if (isset($GLOBALS['siteConfig']['charsetEncoding'])) @header("Content-type: text/html; charset=" . strtoupper($GLOBALS['siteConfig']['charsetEncoding']));
    if (isset($GLOBALS['lastModified'])) @header("Last-Modified: " . gmdate("D, d M Y H:i:s", $GLOBALS['lastModified']) . " GMT", true);

    @header('Content-Length: ' . strlen($bufferString));

//    header("HTTP/1.1 200 OK");

    return ($bufferString);
}
if (isset($_GET['test'])) {
    if (!@ob_start('gz_ob_callback')) {
        die('ob:callback:failure');
    }
}

function closeConnection() {
    @header("Connection: close");
    @ob_end_flush();
    @ob_flush();
    @flush();
    if (function_exists("fastcgi_finish_request")) @fastcgi_finish_request();
}
